#! /bin/bash
if [ ! -f /sys/class/power_supply/BAT0/charge_control_end_threshold ]; then
    echo "applesmc-next kernel module not loaded!"
    exit 1
fi

if [ x"$1" = x ]; then
    echo -n "max charge threshold percentage is " ; cat /sys/class/power_supply/BAT0/charge_control_end_threshold 
elif [ "$1" != "70" -a "$1" != "80" -a "$1" != "90" -a "$1" != "100" ]; then
    echo "usage: batterymax.sh \"percentage\", where "
    echo "\"percentage\" must be one of 70, 80, 90, or 100."
    exit 1
else
    echo "$1" > /sys/class/power_supply/BAT0/charge_control_full_threshold 
    echo "$1" > /sys/class/power_supply/BAT0/charge_control_end_threshold
fi
